<?php
defined('MOODLE_INTERNAL') || die();

function local_spada2025_before_standard_html_head(): string {

    if (defined('CLI_SCRIPT') && CLI_SCRIPT) {
        return '';
    }
    if (during_initial_install()) {
        return '';
    }

    $enabled = get_config('local_spada2025', 'enabled');
    $kodept  = trim((string) get_config('local_spada2025', 'kodept'));

    $baseurl = trim((string) get_config('local_spada2025', 'apispada_baseurl'));
    if ($baseurl === '') {
        $baseurl = 'https://apispada.kemdiktisaintek.go.id'; // default
    }
    $baseurl = rtrim($baseurl, '/');

    if (empty($enabled) || $kodept === '') {
        return '';
    }

    $kodept_js  = json_encode($kodept, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    $baseurl_js = json_encode($baseurl, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

    $html = <<<HTML
<script>
(function() {
    try {
        window.KODE_PT = {$kodept_js};
        var baseUrl = {$baseurl_js};
        if (document.querySelector('script[data-local-spada2025="1"]')) {
            return;
        }

        var script = document.createElement('script');
        script.setAttribute('data-local-spada2025', '1');
        script.src = baseUrl + '/spada.js';
        script.defer = true;
        script.async = true;

        var head = document.head || document.getElementsByTagName('head')[0];
        (head || document.body).appendChild(script);
    } catch (e) {
        console.error('local_spada2025 loader error', e);
    }
})();
</script>
HTML;

    return $html;
}
